unit MainForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  TMainForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    Label1: System.Windows.Forms.Label;
    tbServer: System.Windows.Forms.TextBox;
    tbVirDirName: System.Windows.Forms.TextBox;
    Label2: System.Windows.Forms.Label;
    tbVirDirPath: System.Windows.Forms.TextBox;
    Label3: System.Windows.Forms.Label;
    GroupBox1: System.Windows.Forms.GroupBox;
    sbStatus: System.Windows.Forms.StatusBar;
    btnCreate: System.Windows.Forms.Button;
    rbWeb: System.Windows.Forms.RadioButton;
    rbFTP: System.Windows.Forms.RadioButton;
    btnBrowseFolder: System.Windows.Forms.Button;
    FolderBrowserDialog: System.Windows.Forms.FolderBrowserDialog;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
    procedure btnCreate_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TMainForm))]

implementation

uses
  System.DirectoryServices;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TMainForm.InitializeComponent;
begin
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.tbServer := System.Windows.Forms.TextBox.Create;
  Self.tbVirDirName := System.Windows.Forms.TextBox.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.tbVirDirPath := System.Windows.Forms.TextBox.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.GroupBox1 := System.Windows.Forms.GroupBox.Create;
  Self.rbFTP := System.Windows.Forms.RadioButton.Create;
  Self.rbWeb := System.Windows.Forms.RadioButton.Create;
  Self.sbStatus := System.Windows.Forms.StatusBar.Create;
  Self.btnCreate := System.Windows.Forms.Button.Create;
  Self.btnBrowseFolder := System.Windows.Forms.Button.Create;
  Self.FolderBrowserDialog := System.Windows.Forms.FolderBrowserDialog.Create;
  Self.GroupBox1.SuspendLayout;
  Self.SuspendLayout;
  // 
  // Label1
  // 
  Self.Label1.Location := System.Drawing.Point.Create(8, 8);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(100, 16);
  Self.Label1.TabIndex := 0;
  Self.Label1.Text := 'Server';
  // 
  // tbServer
  // 
  Self.tbServer.Location := System.Drawing.Point.Create(120, 4);
  Self.tbServer.Name := 'tbServer';
  Self.tbServer.Size := System.Drawing.Size.Create(160, 20);
  Self.tbServer.TabIndex := 1;
  Self.tbServer.Text := 'localhost';
  // 
  // tbVirDirName
  // 
  Self.tbVirDirName.Location := System.Drawing.Point.Create(120, 40);
  Self.tbVirDirName.Name := 'tbVirDirName';
  Self.tbVirDirName.Size := System.Drawing.Size.Create(160, 20);
  Self.tbVirDirName.TabIndex := 3;
  Self.tbVirDirName.Text := '';
  // 
  // Label2
  // 
  Self.Label2.Location := System.Drawing.Point.Create(8, 36);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(100, 32);
  Self.Label2.TabIndex := 2;
  Self.Label2.Text := 'Virtual Directory Name';
  // 
  // tbVirDirPath
  // 
  Self.tbVirDirPath.Location := System.Drawing.Point.Create(120, 80);
  Self.tbVirDirPath.Name := 'tbVirDirPath';
  Self.tbVirDirPath.ReadOnly := True;
  Self.tbVirDirPath.Size := System.Drawing.Size.Create(160, 20);
  Self.tbVirDirPath.TabIndex := 5;
  Self.tbVirDirPath.Text := '';
  // 
  // Label3
  // 
  Self.Label3.Location := System.Drawing.Point.Create(8, 72);
  Self.Label3.Name := 'Label3';
  Self.Label3.Size := System.Drawing.Size.Create(100, 32);
  Self.Label3.TabIndex := 4;
  Self.Label3.Text := 'Virtual Directory Path';
  // 
  // GroupBox1
  // 
  Self.GroupBox1.Controls.Add(Self.rbFTP);
  Self.GroupBox1.Controls.Add(Self.rbWeb);
  Self.GroupBox1.Location := System.Drawing.Point.Create(8, 120);
  Self.GroupBox1.Name := 'GroupBox1';
  Self.GroupBox1.Size := System.Drawing.Size.Create(272, 100);
  Self.GroupBox1.TabIndex := 6;
  Self.GroupBox1.TabStop := False;
  Self.GroupBox1.Text := ' Virtual Directory Type';
  // 
  // rbFTP
  // 
  Self.rbFTP.Location := System.Drawing.Point.Create(12, 68);
  Self.rbFTP.Name := 'rbFTP';
  Self.rbFTP.TabIndex := 1;
  Self.rbFTP.Text := 'FTP';
  // 
  // rbWeb
  // 
  Self.rbWeb.Checked := True;
  Self.rbWeb.Location := System.Drawing.Point.Create(12, 24);
  Self.rbWeb.Name := 'rbWeb';
  Self.rbWeb.TabIndex := 0;
  Self.rbWeb.TabStop := True;
  Self.rbWeb.Text := 'Web';
  // 
  // sbStatus
  // 
  Self.sbStatus.Location := System.Drawing.Point.Create(0, 261);
  Self.sbStatus.Name := 'sbStatus';
  Self.sbStatus.Size := System.Drawing.Size.Create(320, 24);
  Self.sbStatus.SizingGrip := False;
  Self.sbStatus.TabIndex := 7;
  // 
  // btnCreate
  // 
  Self.btnCreate.Location := System.Drawing.Point.Create(232, 232);
  Self.btnCreate.Name := 'btnCreate';
  Self.btnCreate.TabIndex := 8;
  Self.btnCreate.Text := '&Create';
  Include(Self.btnCreate.Click, Self.btnCreate_Click);
  // 
  // btnBrowseFolder
  // 
  Self.btnBrowseFolder.Location := System.Drawing.Point.Create(283, 80);
  Self.btnBrowseFolder.Name := 'btnBrowseFolder';
  Self.btnBrowseFolder.Size := System.Drawing.Size.Create(24, 20);
  Self.btnBrowseFolder.TabIndex := 9;
  Self.btnBrowseFolder.Text := '...';
  Include(Self.btnBrowseFolder.Click, Self.Button2_Click);
  // 
  // TMainForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(320, 285);
  Self.Controls.Add(Self.btnBrowseFolder);
  Self.Controls.Add(Self.btnCreate);
  Self.Controls.Add(Self.sbStatus);
  Self.Controls.Add(Self.GroupBox1);
  Self.Controls.Add(Self.tbVirDirPath);
  Self.Controls.Add(Self.tbVirDirName);
  Self.Controls.Add(Self.tbServer);
  Self.Controls.Add(Self.Label3);
  Self.Controls.Add(Self.Label2);
  Self.Controls.Add(Self.Label1);
  Self.MaximizeBox := False;
  Self.Name := 'TMainForm';
  Self.Text := 'Create IIS Virtual Directories';
  Self.GroupBox1.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TMainForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TMainForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TMainForm.btnCreate_Click(sender: System.Object; e: System.EventArgs);
var
  Schema, IISRootPath : string;
  RootDirectortEntry, NewVirtualDirectory : DirectoryEntry;
begin
  if rbWeb.Checked then
  begin
    Schema := 'IIsWebVirtualDir';
    IISRootPath := '/W3SVC/1/Root';
  end
  else
  begin
    Schema := 'IIsFtpVirtualDir';
    IISRootPath := '/MSFTPSVC/1/Root';
  end;

  RootDirectortEntry := DirectoryEntry.Create('IIS://' + tbServer.Text + IISRootPath );
  try
    RootDirectortEntry.RefreshCache;

    NewVirtualDirectory := RootDirectortEntry.Children.Add( tbVirDirName.Text, Schema );
    NewVirtualDirectory.Properties['Path'].Insert( 0, tbVirDirPath.Text );
    NewVirtualDirectory.CommitChanges;
    RootDirectortEntry.CommitChanges;

    // Create an Application if it is a Web Virtual Directory
    // So that is realises that it should sit off the root.
    if rbWeb.Checked then
    begin
      NewVirtualDirectory.Invoke( 'AppCreate' , [ true ] );
    end;

    // Save all changes
    NewVirtualDirectory.CommitChanges;
    RootDirectortEntry.CommitChanges;

    // Close gracefully
    NewVirtualDirectory.Close;
    RootDirectortEntry.Close;

    // Update StatusAbr for User
    sbStatus.Text := 'Virtual Directory : ' + tbVirDirName.Text + '( ' + tbVirDirPath.Text + ' ), has been created.';
  except on Ex : Exception do
    begin
      sbStatus.Text := Ex.Message;
    end;
  end;
end;

procedure TMainForm.Button2_Click(sender: System.Object; e: System.EventArgs);
begin
  if ( FolderBrowserDialog.ShowDialog = System.Windows.Forms.DialogResult.OK ) then
  begin
    tbVirDirPath.Text := FolderBrowserDialog.SelectedPath;
  end;
end;

end.
